//propane tank
//m.miller 05.05.23


#include "propane/propane_materials.inc"

// -----------------------------------------------------------------------------------------
//                      T A N K   B O D Y
//------------------------------------------------------------------------------------------  
#declare rad1 = 11.3  ; 
#declare rad2 = .35  ;
#declare p1 = <0.000, 0.000, 0.000>  ;
#declare p2 = <0.000, 5.485, 0.000>  ;
#declare p3 = <0.000, 38.854, 0.000>  ;
#declare p4 = <0.000, 40.5, 0.000>  ;
#declare p5 = <0.000, 76.565, 0.000>  ;
#declare p6 = <0.000, 80, 0.000>  ;
#declare p7 = <0.000, 81.127, 0.000>  ;
#declare p8 = <0.000, 83.243, 0.000>  ;

#declare body =
union {
    torus { rad1-rad2, rad2 translate <0,.4,0>}         //bottom edge
    cylinder {<0,rad2,0>,p2,rad1}                       //base sleeve
    torus { rad1, rad2 scale <1,2,1> translate p2}
    cylinder {p2, p3,rad1+rad2}                         //2nd sleeve
    torus { rad1+rad2, rad2 scale <1,2,1> translate p3}
    cylinder {p3, p5,rad1+rad2+rad2}                    //3rd sleeve
    difference {
        sphere { <0,0,0>,1 scale <rad1+rad2*2,3,rad1+rad2*2> translate p5 }
        sphere {<0,0,0>,2 translate <0,79,-7> }
    }
    cylinder { p6,p8,3 }
    torus { 3.3, .6 scale <1,.8,1> translate p6}
    cylinder { p7,p8,3.5 }
    torus { 2,.25 rotate <-8,0,0> translate <0,78.9,-7>}
    material { M_blue_dark_gloss} 
    
    
}


#declare label =
union {
   cylinder {<0,0,0>, <0,34,0>, rad1+rad2+rad2+.1} 
   material {M_propane_label}
   translate p4
}



// -----------------------------------------------------------------------------------------
//                      T O R C H
//------------------------------------------------------------------------------------------ 

#declare p5 = <0.000, 11.768, 0.000>  ;
#declare p4 = <0.000, 9.514, 0.000>  ;
#declare p3 = <0.000, 5.928, 0.000>  ;
#declare p2 = <0.000, 4.066, 0.000>  ;
#declare p1 = <0.000, 0.000, 0.000>  ;

#declare torch =
union {
    cylinder {p1,p5,2}
    sphere { <0,0,0>, 2 scale <1,.1,1> translate p5} 
    cylinder {p1,p2,4.5}
    sphere { <0,0,0>, 4.5 scale <1,.1,1> translate p1}   
    sphere { <0,0,0>, 4.5 scale <1,.1,1> translate p2} 
    difference {
        sphere { <0,0,0>, 4.25 scale <1,.8,1> translate <0,7.7,0>}
        plane {<0,1,0> 0 translate p3} 
        plane {<0,-1,0> 0 translate p4} 
        
        plane {<0,0,1> 0 translate <0,0,-2.5>} 
        plane {<0,0,-1> 0 translate <0,0,2.5>}
    }
    #declare sz=1.6;
    sphere_sweep {
         cubic_spline
         7,
         <-0.000, 10.675, 0.000> , sz
         <-0.000, 10.675, 0.000> , sz
         <-0.000, 17.802, 0.000> , sz
         <-0.141, 19.354, -0.000> , sz
         <-0.677, 20.849, -0.000> , sz
         <-2.276, 23.860, -0.000> , sz
         <-3.781, 26.776, -0.000> , sz
         tolerance 0.000001
    }   
    
    
    cylinder {<0,0,0>,<1,0,0>,1.5 translate <3.8,7.7,0>}
    cylinder {<0,0,0>,<3,0,0>,1 translate <3.8,7.7,0>}
    
    union {
       difference {
           cylinder {<0,0,0>,<1.3,0,0>,4.5 translate <0,0,0>}
           #declare knotch = cylinder {<-5,0,0>,<5,0,0>,.75 translate <0,0,-4.5>}
           #for (i,0,23) 
                object { knotch rotate <i*15,0,0>}
           #end
       }
       
       sphere {<0,0,0>,1 scale <1,3.2,3.2> translate <1.3,0,0>}
       material {M_black_plastic}
       translate <6.8,7.7,0>
    }
    


    
    translate <0,83,0>
}


#declare torch_tip =  
#declare sz=1.9;
union { 
    difference {
        cylinder {<0,0,0>,<0,13,0>, sz} 
        cylinder {<0,1,0>,<0,14,0>, sz-.1}
        cylinder {<0,3,-10>,<0,3,10>,.8}
        cylinder {<-10,3,0>,<10,3,0>,.8} 
    }
    rotate <0,0,29>
    translate <-2,106.3,0>
}




// -----------------------------------------------------------------------------------------
//                      P R O P A N E    T A N K 
//------------------------------------------------------------------------------------------ 
#declare propane_tank =
union {
    object { body }
    object { label } 
    union {
    object { torch material {M_brass_aged scale <.5,.5,.5>}} 
    object { torch_tip material {M_brass_aged scale <.3,.3,.35>}} 
    rotate <0,30,0>
    }
}

